function [a]=sens_plot(skt,sens,n)
  if (nargin==1)
    sens=1;
    n=100;
  end
 type=4;
 sinlength=10000.0/32768.0;
pos=[];
  
udpspisetup(skt,10000000,16);
sens_put(skt,(sens*256)+17,type); %Type 4
sens_put(skt,1,1);
sens_put(skt,sens*256,[3]);

for x=1:n
a=double(sens_get(skt,sens*256+2,1));
pos=[pos a];
end
%measure is signed - so convert from unsigned to signed
idx=find(pos>32767.0);
pos(idx)=pos(idx)-65536;
pos=pos*sinlength;
phdl=plot(pos);
s=sprintf('mean pos= %2.4fmm  rms=%2.4fmm',mean(pos),sqrt(var(pos)));
ylabel('um');
thdl=title(s);
grid on;
while (size(kbhit(1))(1)<1) 
  a=double(sens_get(skt,sens*256+2,1));
  if(min(size(a))>0)
  if(a>32767.0); a=a-65536; end
  a=a*sinlength;
  pos=[pos(2:end) a];
  set(phdl,'ydata',pos);
  set(thdl,'string',sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos))));
  drawnow;
  end
end
  